% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unwrap_fn.R
\name{unwrap_cols}
\alias{unwrap_cols}
\title{Unwrap values and clean up NAs used as padding}
\usage{
unwrap_cols(df, groupingVar, separator)
}
\arguments{
\item{df}{A data frame with wrapped values and an inconsistent number of NA
values used to as within-group padding.}

\item{groupingVar}{Name of the variable describing the observational units.}

\item{separator}{Character string defining the separator that will delimit
the elements of the unwrapped value.}
}
\value{
A summarized tibble. Order is preserved in the grouping variable by
making it a factor.
}
\description{
Unwrap values and clean up NAs used as padding
}
\details{
This is roughly the opposite of \code{tidyr::separate_rows()}.
}
\examples{
data(primates2017_wrapped)
# using commas to separate elements
unwrap_cols(primates2017_wrapped, scientific_name, ", ")

# separating with semicolons
df <- data.frame(
  ounits = c("A", NA, "B", "C", "D", NA),
  vals = c(1, 2, 2, 3, 1, 3)
)
unwrap_cols(df, ounits, ";")
}
