#  Risk of rank generated by tree-based method
#' @title Risk of rank generated by tree-based method
#' @description list out all the possible variables, the order is according to P-value from small to large, and the cut-off-point has been optimal.
#' @param X.mat :n by p matrix of covariates, where n is the sample size and p is the number of covariates
#' @param tree :Tree structure made by uni.tree() function
#' @details If the tree exists k terminal nodes, then the response 1 respresents the lowest risk and k represents the highest
#' @examples
#' data(Lung,package="compound.Cox")
#' train_Lung=Lung[which(Lung[,"train"]==TRUE),] #select training data
#' t.vec=train_Lung[,1]
#' d.vec=train_Lung[,2]
#' x.mat=train_Lung[,-c(1,2,3)]
#' res=uni.tree(t.vec,d.vec,x.mat,P.value=0.01,d0=0.01,S.plot=FALSE,score=TRUE)
#' risk.classification(res,x.mat)
#' @return a sequence of risk of rank correspond to each sample
#' @export
risk.classification=function(tree,X.mat){
  #risk.index function helps individual data to drop into the terminal node according to the covariate space
  risk.index=function(tree,X.vec){
    if(as.character(unlist(tree[[1]]))[1] == "terminal node"){
      return(as.double(as.character(unlist(tree[[1]]))[2]))  #[2] is the risk index which the terminal nodes scored
    }else{
      name = as.character(unlist(tree[[1]]))[4]
      cut_off_point = as.double(as.character(unlist(tree[[1]]))[5])  #[5] is the cut-off-point
      Zvalue = as.double(as.character(unlist(tree[[1]]))[6])  #[6] is the Z-value produce by logrank or score
      #below is a logical process to identify which subtree a data point should drop down
      if(Zvalue <= 0 ){
        if(X.vec[name] <= cut_off_point){
          subtree = tree[[2]]
          return(risk.index(subtree,X.vec))
        }else{
          subtree = tree[[3]]
          return(risk.index(subtree,X.vec))
        }
      }else{
        if(X.vec[name] > cut_off_point){
          subtree = tree[[2]]
          return(risk.index(subtree,X.vec))
        }else{
          subtree=tree[[3]]
          return(risk.index(subtree,X.vec))
        }
      }
    }
  }
  #we use risk.index to show out all samples risk rank
  index=c()
  for(i in 1:nrow(X.mat)){
    index[i] = risk.index(tree,X.mat[i,])
  }
  result=c()
  for (j in 1:length(unique(index))) {
    result[which(index==sort(unique(index))[j])]=j
  }
  names(result)=c(1:length(result))
  return(result)
}
