% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Harvard.R
\docType{data}
\name{harvard_3}
\alias{harvard_3}
\title{Web colors of Harvard University, USA}
\format{
An object of class \code{character} of length 8.
}
\source{
Color definitions are based on the
\href{https://identityguide.hms.harvard.edu/color/}{Color manual}.
}
\usage{
harvard_3
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{harvard_3} provides the 8 web colors
of the \href{https://www.harvard.edu/}{Harvard University}, USA.
}
\details{
Additional web colors have been provided to allow for highlighting or accenting key information.
In general, tertiary colors should be used sparingly so they do not to overwhelm the primary and secondary palettes.
These colors are
\code{"indigo"} (defined as RGB 41/51/82, HEX #293352),
\code{"blue_bonnet"} (defined as RGB 78/132/196, HEX #4E84C4),
\code{"ivy"} (defined as RGB 82/133/76, HEX #52854C),
\code{"pear"} (defined as RGB 195/215/164, HEX #C3D7A4),
\code{"lemon"} (defined as RGB 255/219/109 , HEX #FFDB6D),
\code{"saffron"} (defined as RGB 232/125/30, HEX #D16103),
\code{"gold"} (defined as RGB 196/150/26 , HEX #C4961A), and
\code{"creme"} (defined as RGB 244/237/202, HEX #F4EDCA).

For \code{"saffron"} the RGB and HEX definitions differ numerically.
Our color palette is based on the HEX definition.
}
\examples{
harvard_3
unikn::seecol(harvard_3, main = "Web colors Harvard University") # view color palette

}
\seealso{
\code{\link{harvard_1}} for primary colors of Harvard University;
\code{\link{harvard_2}} for accent colors of Harvard University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{CMU_1_core}},
\code{\link{CMU_2_tartan}},
\code{\link{CMU_3_campus}},
\code{\link{UCLA_1}},
\code{\link{UCLA_2}},
\code{\link{UCLA_3}},
\code{\link{UCLA_4}},
\code{\link{UCSD_1}},
\code{\link{UCSD_2}},
\code{\link{UCSD_3}},
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{columbia}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_accent}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2_accent}},
\code{\link{stanford_3_web}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
