% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bergen.R
\docType{data}
\name{bergen_1}
\alias{bergen_1}
\title{Main colours of the University of Bergen, Norway}
\format{
An object of class \code{character} of length 4.
}
\source{
Colour definitions are based on \href{https://www.uib.no}{UiB}'s 
\href{https://manual.uib.no/en/brand-guide/}{brand guide} (HTML).
}
\usage{
bergen_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{bergen_1} provides the four main colours 
of the \href{https://www.uib.no}{University of Bergen}, Norway.
}
\details{
\code{bergen_1} is based on HEX color definitions.


In official communication from the organization, 
blue and red are used as the main colours. 
The colours can be used separately or in combination with the additional colors.
Examples of use are on business cards, letterheads, diplomas and other key documents. 
These surfaces have a long life and should not vary too much in expression.

UiB has many fields and units, and the communication must cover various topics and target groups. 
In broader communication, you can also use green (see \code{\link{bergen_2}}). 
Examples can be power-point, websites, video, brochures, reports, 
conference material, social media and advertisements.
}
\examples{
bergen_1
unikn::seecol(bergen_1, 
              main = "Main colours of the University of Bergen, Norway")  # view palette

}
\seealso{
\code{\link{bergen_2}} for additional colours of the University of Bergen; 
\code{\link{bergen_3}} for support colours of the University of Bergen; 
\code{\link{bergen_4}} for text colours of the University of Bergen; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Norwegian university color palettes: 
\code{\link{bergen_2}},
\code{\link{bergen_3}},
\code{\link{bergen_4}},
\code{\link{oslo}}
}
\author{
\strong{unicol}, 2023-10-11.
}
\concept{Norwegian university color palettes}
\keyword{datasets}
