% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pals.R
\docType{data}
\name{mpg_pal}
\alias{mpg_pal}
\title{Default colors of the Max-Planck-Gesellschaft.}
\format{
An object of class \code{character} of length 3.
}
\source{
Color definitions are based on 
\url{https://docplayer.org/2328711-Max-planck-institut-das-erscheinungsbild-der-max-planck-gesellschaft-4-ueberarbeitete-auflage.html}.
}
\usage{
mpg_pal
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{mpg_pal} provides the default color palette 
of the \href{https://www.mpg.de/en}{Max-Planck-Gesellschaft}, Germany.
}
\details{
The color \code{"white"} was added to enable symmetrical color gradients.
}
\examples{
mpg_pal
seecol(mpg_pal)  # view color palette
demopal(mpg_pal, type = 1, main = "Using MPG colors")

}
\seealso{
\code{\link{uni_konstanz_pref}} for preferred colors of the University of Konstanz;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other contributed color palettes: 
\code{\link{eth_pal_grey}},
\code{\link{eth_pal_light}},
\code{\link{eth_pal}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_konstanz_pref}},
\code{\link{uni_konstanz}},
\code{\link{uni_princeton_0}},
\code{\link{uni_princeton_1}},
\code{\link{uni_princeton_2}}
}
\author{
Hansjoerg Neth, 2022-10-20.
}
\concept{contributed color palettes}
\keyword{datasets}
