% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_def_1.R
\docType{data}
\name{pal_unikn_ppt}
\alias{pal_unikn_ppt}
\title{uni.kn secondary color palette (ppt version).}
\format{
An object of class \code{data.frame} with 1 rows and 10 columns.
}
\usage{
pal_unikn_ppt
}
\description{
\code{pal_unikn_ppt} provides an alternative uni.kn color palette  
as a data frame containing 10 colors.
}
\details{
This is a secondary (ppt) variant with more muted colors.

See \code{\link{pal_unikn}} for the primary/default (web/sRGB) scale 
and \url{https://www.uni-konstanz.de/en/university/news-and-media/create-online-and-print-media/corporate-design/} for details.
}
\examples{
pal_unikn_ppt
dim(pal_unikn_ppt)  # 1 10

# Access by position:
pal_unikn_ppt[2]    # 2nd named color "seeblau3" (as df)
pal_unikn_ppt[[2]]  # 2nd color value "#59B6DC"

# Access by name: 
pal_unikn_ppt["seeblau3"]    # color "seeblau3" (as df)
pal_unikn_ppt[["seeblau3"]]  # color value "#59B6DC"

# Plotting palette:
seecol(pal_unikn_ppt)

}
\seealso{
\code{\link{pal_unikn}} for the unikn default color palette with all 5 colors of \code{\link{pal_seeblau}}; 
\code{\link{pal_unikn_pref}} for a uni.kn color palette with all preferred colors; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes.

Other color palettes: 
\code{\link{pal_bordeaux}},
\code{\link{pal_grau}},
\code{\link{pal_karpfenblau}},
\code{\link{pal_peach}},
\code{\link{pal_petrol}},
\code{\link{pal_pinky}},
\code{\link{pal_seeblau}},
\code{\link{pal_seegruen}},
\code{\link{pal_signal}},
\code{\link{pal_unikn_dark}},
\code{\link{pal_unikn_light}},
\code{\link{pal_unikn_pair}},
\code{\link{pal_unikn_pref}},
\code{\link{pal_unikn_web}},
\code{\link{pal_unikn}}
}
\concept{color palettes}
\keyword{datasets}
