% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pals.R
\docType{data}
\name{uni_princeton_2}
\alias{uni_princeton_2}
\title{Colors of Princeton University (on black backgrounds).}
\format{
An object of class \code{character} of length 3.
}
\source{
Color definitions are based on 
\url{https://communications.princeton.edu/guides-tools/logo-graphic-identity}.
}
\usage{
uni_princeton_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_princeton_2} provides the two basic colors 
of \href{https://www.princeton.edu/}{Princeton University}, NJ, USA, 
for use on black backgrounds.
}
\details{
The color \code{"black"} was added to enable symmetrical color gradients.
}
\examples{
uni_princeton_2
opar <- par(no.readonly = TRUE)
par(bg = "black", col.main = "white", col = "grey")
seecol(uni_princeton_2, col_brd = "grey", lwd = 2)  # view color palette
demopal(uni_princeton_2, type = 3, main = "Colors of Princeton University")
par(opar)

}
\seealso{
\code{\link{uni_princeton_0}} for basic Princeton University colors; 
\code{\link{uni_princeton_1}} for Princeton University colors (on white backgrounds); 
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other contributed color palettes: 
\code{\link{eth_pal_grey}},
\code{\link{eth_pal_light}},
\code{\link{eth_pal}},
\code{\link{mpg_pal}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_konstanz_pref}},
\code{\link{uni_konstanz}},
\code{\link{uni_princeton_0}},
\code{\link{uni_princeton_1}}
}
\author{
Hansjoerg Neth, 2022-10-20.
}
\concept{contributed color palettes}
\keyword{datasets}
