% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_functions.R
\name{uniset_getFiles}
\alias{uniset_getFiles}
\title{Get Uniset Files}
\usage{
uniset_getFiles(
  taPaName = NULL,
  setupFunc = NULL,
  where = NULL,
  taPaSH = "def",
  taPaObj = "settings",
  tmpl = "_TEMPLATE"
)
}
\arguments{
\item{taPaName}{Character length one. The name of the target package.}

\item{setupFunc}{Character length one. The name of the function
\strong{in the target package} that is containing the setup-function
\code{\link{uniset_setup}}.}

\item{where}{Character length one. The location where the folder with the
resulting four files should be copied to. Defaults to 'NULL'. If left at the
default 'NULL', the location should be selectable interactively. Provide a
character length one holding a valid path to an existing folder to copy the
folder containing the four required files there.}

\item{taPaSH}{Character length one. The name of the variable to be defined in
the '.Renviron' file, leading to the place where the settings.R file for the
target package will be stored. If left at the default 'def', \code{'taPaName_SH'}
will be used, with 'taPaName' being the value provided at the argument
'taPaName'.}

\item{taPaObj}{Character length one. The name of the object holding the list
with the key-value pairs that can be defined to be used in the target package.
Can be left at the default 'settings'.}

\item{tmpl}{Character length one. the Character string that will be appended
to the fresh settings file that is copied (by the target package) to the users
settings home directory if updating the key=value pairs was not successful.
Can be left at the default '_TEMPLATE'.}
}
\value{
Creates a folder at the location specified at argument 'where' with the
four files to be moved into the target package in it. Returns an (invisible)
character holding the path of the folder where the three files were written
into.
}
\description{
Function to generate the four files required in the target
package (i.e. the package that should be enabled to use the package 'uniset').
}
\details{
Look at the content of the four generated files for information on
where they should be moved.
}
\section{Note}{
 Please refer to \code{\link{uniset}} for a link to examples
and a real-world demo.
}

\examples{
{
library(uniset)
# first copy the target package example into tempdir
to <- tempdir()
from <- paste0(path.package("uniset"), "/examples/dogPack")
file.copy(from, to, recursive = TRUE) 
# now copy the four required files
uniset_getFiles("dogPack", setupFunc="nameOfSetupFunc", where=to)
# Now manually move the four files according to the instructions contained 
# in them.
}
}
\seealso{
\code{\link{uniset_copyFilesToPackage}}
}
