% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\docType{class}
\name{conditionList}
\alias{conditionList}
\alias{conditionList-class}
\title{Contains A List of Conditions}
\description{
Condition lists are S4 classes that contain \code{\link{condition}} objects
emitted by \code{unitizer} tests.  Condition lists will typically be
accessible via the \code{.NEW} and \code{.REF} \code{unitizer} test objects.
You can access individual conditions using \code{[[} (see examples), and for
the most part you can treat them as you would an S3 list containing
conditions.
}
\details{
There are \code{show} and \code{all.equal} methods implemented for them, the
latter of which is used to compare conditions across tests.  If you wish to
implement a custom comparison function via \code{\link{unitizer_sect}}, your
function will need to compare \code{conditionList} objects.
}
\section{Slots}{

\describe{
\item{\code{.items}}{list of conditions}
}}

\note{
Implemented as an S4 class to avoid \code{setOldClass} and related
compatibility issues; the \code{conditionList} class contains
\code{\link{unitizerList}}.
}
\examples{
## Create a test item as you would find normally at the `unitizer` prompt
## for illustrative purposes:
.NEW <- mock_item()
## Access the first condition from the new test evaluation
.NEW$conditions[[1L]]
## loop through all conditions
for(i in seq_along(.NEW$conditions)) .NEW$conditions[[i]]
}
\seealso{
\code{\link{unitizer_sect}}, \code{\link{unitizerList}},
  \code{\link{all.equal.conditionList}}
}
