% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{getuid}
\alias{getuid}
\alias{getgid}
\alias{geteuid}
\alias{getegid}
\alias{getpid}
\alias{getppid}
\alias{getpgid}
\alias{getpriority}
\alias{setuid}
\alias{seteuid}
\alias{setgid}
\alias{setegid}
\alias{setpgid}
\alias{setpriority}
\alias{kill}
\title{Process Info}
\usage{
getuid()

getgid()

geteuid()

getegid()

getpid()

getppid()

getpgid()

getpriority()

setuid(uid)

seteuid(uid)

setgid(gid)

setegid(gid)

setpgid(pgid = 0)

setpriority(prio)

kill(pid, signal = SIGTERM)
}
\arguments{
\item{uid}{User ID from \code{/etc/passwd}.}

\item{gid}{Group ID from \code{/etc/group}.}

\item{pgid}{Process Group ID. Default \code{0} sets pgid to the current pid.}

\item{prio}{Priority level}

\item{pid}{process ID (integer)}

\item{signal}{a signal number (integer), defaults to \link[tools:SIGTERM]{tools::SIGTERM}.}
}
\description{
Get or set attributes of the current process.
}
\details{
Acronyms stand for:
\itemize{
\item \code{pid} Process ID
\item \code{ppid} Parent-Process ID
\item \code{pgid} Process-Group ID
\item \code{uid} User ID
\item \code{euid} Effective User ID
\item \code{gid} Group ID
\item \code{egid} Effective Group ID
\item \code{prio} Priority level
}

An unprivileged (non-root) process cannot change it's \code{uid} and only lower
process priority (higher value).
}
\examples{
# Current User:
getuid()
# Current UserGroup:
getgid()
# Current UserGroup:
geteuid()
# Current UserGroup:
getegid()
# Process ID
getpid()
# parent PID:
getppid()
# Process group id:
getpgid()

# Detach process group
setpgid(0)
getpgid()
# Process priority:
getpriority()
# Decrease priority
setpriority(getpriority() + 1)
}
\references{
\href{http://man7.org/linux/man-pages/man2/getuid.2.html}{GETUID(2)}
\href{http://man7.org/linux/man-pages/man2/getpid.2.html}{GETPID(2)}
\href{http://man7.org/linux/man-pages/man2/getpgid.2.html}{GETPGID(2)}
\href{http://man7.org/linux/man-pages/man2/getpriority.2.html}{GETPRIORITY(2)}
}
