% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{asCombination}
\alias{asCombination}
\title{creates a new UpSet set combination structure}
\usage{
asCombination(
  name,
  elems = c(),
  type = "intersection",
  sets = strsplit(name, "&"),
  cardinality = length(elems),
  color = NULL
)
}
\arguments{
\item{name}{name of the set combination}

\item{elems}{the elements of the set combination}

\item{type}{the set combination type (intersection,distinctIntersection,union,combination)}

\item{sets}{the sets this combination is part of}

\item{cardinality}{the cardinality of the set, default to \code{length(elems)}}

\item{color}{the color of the set}
}
\value{
the set object
}
\description{
creates a new UpSet set combination structure
}
\examples{
asCombination("a", c(1, 2, 3))
}
