test_that(".is_count() works", {
    expect_true(.is_count(1L))
    expect_true(.is_count(8L))
    expect_false(.is_count(-2L))
    expect_false(.is_count(0))
    expect_false(.is_count(15.2))
    expect_false(.is_count(NA))
    expect_false(.is_count(NA_character_))
    expect_false(.is_count(NA_integer_))
    expect_false(.is_count(NA_real_))
    expect_false(.is_count(c(1L, 2L)))
    expect_false(.is_count("a-number"))
    expect_false(.is_count(NULL))
    expect_false(.is_count(TRUE))
})

test_that(".is_flag() works", {
    expect_true(.is_flag(TRUE))
    expect_true(.is_flag(FALSE))
    expect_false(.is_flag(-1))
    expect_false(.is_flag(-1L))
    expect_false(.is_flag(0))
    expect_false(.is_flag(0L))
    expect_false(.is_flag(1))
    expect_false(.is_flag(1L))
    expect_false(.is_flag(15.2))
    expect_false(.is_flag(NA))
    expect_false(.is_flag(NA_character_))
    expect_false(.is_flag(NA_integer_))
    expect_false(.is_flag(NA_real_))
    expect_false(.is_flag(c(1L, 2L)))
    expect_false(.is_flag("a-number"))
    expect_false(.is_flag(NULL))
})

test_that(".is_string() works", {
    expect_true(.is_string("abc"))
    expect_true(.is_string("  "))
    expect_false(.is_string(""))
    expect_false(.is_string(-2L))
    expect_false(.is_string(0))
    expect_false(.is_string(15.2))
    expect_false(.is_string(NA))
    expect_false(.is_string(NA_character_))
    expect_false(.is_string(NA_integer_))
    expect_false(.is_string(NA_real_))
    expect_false(.is_string(c(1L, 2L)))
    expect_false(.is_string(NULL))
    expect_false(.is_string(TRUE))
})

test_that(".is_writeable() works", {
    expect_true(.is_writeable(getwd()))
    expect_false(.is_writeable(file.path(tempdir(), "some-nonsense")))
    expect_false(.is_writeable(""))
    expect_false(.is_writeable(-2L))
    expect_false(.is_writeable(0))
    expect_false(.is_writeable(15.2))
    expect_false(.is_writeable(NA))
    expect_false(.is_writeable(NA_character_))
    expect_false(.is_writeable(NA_integer_))
    expect_false(.is_writeable(NA_real_))
    expect_false(.is_writeable(c(1L, 2L)))
    expect_false(.is_writeable("a-number"))
    expect_false(.is_writeable(NULL))
    expect_false(.is_writeable(TRUE))
})
