% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste.R
\name{paste_freq}
\alias{paste_freq}
\title{Paste frequency}
\usage{
paste_freq(x, y, na.rm = TRUE, percent.sign = TRUE, digits = 1)
}
\arguments{
\item{x}{Data.frame, numeric, or non-numeric. The numerator.}

\item{y}{Data.frame, numeric, or non-numeric. The denominator. A single
denominator may be used for multiple numerators or one denominator for each
numerator.}

\item{na.rm}{Logical. Whether to ignore NA's when tallying non-numeric data.}

\item{percent.sign}{Logical. Indicates percent sign should be printed
with frequencies.}

\item{digits}{Integer. Number of digits to round to.}
}
\value{
A character vector of count(s) with frequencies.
}
\description{
Creates a human-readable frequency from count(able) data. Automatically
tallies non-numeric data types (nrow or length) and supports vectorized data
methods.
}
\examples{
library(tibble)

# Numeric
paste_freq(20, 100)

# Tibble
data_tibble <- tibble(column = c(1:100))
paste_freq(data_tibble[1:20,], data_tibble)

# Mixed data types
paste_freq(20, data_tibble)

# Single denominator for multiple numerators
paste_freq(c(10,20,30), 100)
}
