% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_mlknn.R
\name{mlknn}
\alias{mlknn}
\title{Multi-label KNN (ML-KNN) for multi-label Classification}
\usage{
mlknn(mdata, k = 10, s = 1, distance = "euclidean", ...,
  cores = getOption("utiml.cores", 1), seed = getOption("utiml.seed",
  NA))
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{k}{The number of neighbors. (Default: \code{10})}

\item{s}{Smoothing parameter controlling the strength of uniform prior. When
it is set to be 1, we have the Laplace smoothing. (Default: \code{1}).}

\item{distance}{The name of method used to compute the distance. See
\code{\link[stats]{dist}} to the list of options.
(Default: \code{"euclidian"})}

\item{...}{Not used.}

\item{cores}{Ignored because this method does not support multi-core.}

\item{seed}{Ignored because this method is deterministic.}
}
\value{
An object of class \code{MLKNNmodel} containing the set of fitted
 models, including:
 \describe{
   \item{labels}{A vector with the label names.}
   \item{prior}{The prior probability of each label to occur.}
   \item{posterior}{The posterior probability of each label to occur given
     that k neighbors have it.}
 }
}
\description{
Create a ML-KNN classifier to predict multi-label data. It is a multi-label
lazy learning, which is derived from the traditional K-nearest neighbor (KNN)
algorithm. For each unseen instance, its K nearest neighbors in the training
set are identified and based on statistical information gained from the label
sets of these neighboring instances, the maximum a posteriori (MAP) principle
is utilized to determine the label set for the unseen instance.
}
\examples{
model <- mlknn(toyml, k=3)
pred <- predict(model, toyml)
}
\references{
Zhang, M.L. L., & Zhou, Z.H. H. (2007). ML-KNN: A lazy learning approach
   to multi-label learning. Pattern Recognition, 40(7), 2038-2048.
}
\concept{Adaptatio methods}
