% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_eps.R
\name{predict.EPSmodel}
\alias{predict.EPSmodel}
\title{Predict Method for Ensemble of Pruned Set Transformation}
\usage{
\method{predict}{EPSmodel}(object, newdata, threshold = 0.5,
  probability = getOption("utiml.use.probs", TRUE), ...,
  cores = getOption("utiml.cores", 1), seed = getOption("utiml.seed",
  NA))
}
\arguments{
\item{object}{Object of class '\code{EPSmodel}'.}

\item{newdata}{An object containing the new input data. This must be a
matrix, data.frame or a mldr object.}

\item{threshold}{A threshold value for producing bipartitions. (Default: 0.5)}

\item{probability}{Logical indicating whether class probabilities should be
returned. (Default: \code{getOption("utiml.use.probs", TRUE)})}

\item{...}{Others arguments passed to the base algorithm prediction for all
subproblems.}

\item{cores}{The number of cores to parallelize the prediction. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. (Default:
\code{options("utiml.seed", NA)})}
}
\value{
An object of type mlresult, based on the parameter probability.
}
\description{
This function predicts values based upon a model trained by
 \code{\link{eps}}. Different from the others methods the probability value,
 is actually, the sum of all probability predictions such as it is described
 in the original paper.
}
\examples{
model <- eps(toyml, "RANDOM")
pred <- predict(model, toyml)
}
\seealso{
\code{\link[=eps]{Ensemble of Pruned Set (EPS)}}
}
