% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_ppt.R
\name{ppt}
\alias{ppt}
\title{Pruned Problem Transformation for multi-label Classification}
\usage{
ppt(
  mdata,
  base.algorithm = getOption("utiml.base.algorithm", "SVM"),
  p = 3,
  info.loss = FALSE,
  ...,
  cores = getOption("utiml.cores", 1),
  seed = getOption("utiml.seed", NA)
)
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{base.algorithm}{A string with the name of the base algorithm. (Default:
\code{options("utiml.base.algorithm", "SVM")})}

\item{p}{Number of instances to prune. All labelsets that occurs p times or
less in the training data is removed. (Default: 3)}

\item{info.loss}{Logical value where \code{TRUE} means discard infrequent
labelsets and \code{FALSE} means reintroduce infrequent labelsets via
subsets. (Default: FALSE)}

\item{...}{Others arguments passed to the base algorithm for all subproblems}

\item{cores}{Not used}

\item{seed}{An optional integer used to set the seed. (Default:
\code{options("utiml.seed", NA)})}
}
\value{
An object of class \code{PPTmodel} containing the set of fitted
  models, including:
  \describe{
   \item{labels}{A vector with the label names.}
   \item{model}{A LP model contained only the most common labelsets.}
  }
}
\description{
Create a Pruned Problem Transformation model for multilabel classification.
}
\details{
Pruned Problem Transformation (PPT) is a multi-class transformation that
remove the less common classes to predict multi-label data.
}
\examples{
model <- ppt(toyml, "RANDOM")
pred <- predict(model, toyml)

\dontrun{
##Change default configurations
model <- ppt(toyml, "RF", p=4, info.loss=TRUE)
}
}
\references{
Read, J. (2008). A pruned problem transformation method for multi-label
  classification. In Proceedings of the New Zealand Computer Science
  Research Student Conference (pp. 143-150).
}
\seealso{
Other Transformation methods: 
\code{\link{brplus}()},
\code{\link{br}()},
\code{\link{cc}()},
\code{\link{clr}()},
\code{\link{ctrl}()},
\code{\link{dbr}()},
\code{\link{ebr}()},
\code{\link{ecc}()},
\code{\link{eps}()},
\code{\link{esl}()},
\code{\link{homer}()},
\code{\link{lift}()},
\code{\link{lp}()},
\code{\link{mbr}()},
\code{\link{ns}()},
\code{\link{prudent}()},
\code{\link{ps}()},
\code{\link{rakel}()},
\code{\link{rdbr}()},
\code{\link{rpc}()}

Other Powerset: 
\code{\link{eps}()},
\code{\link{lp}()},
\code{\link{ps}()},
\code{\link{rakel}()}
}
\concept{Powerset}
\concept{Transformation methods}
