% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_rakel.R
\name{predict.RAkELmodel}
\alias{predict.RAkELmodel}
\title{Predict Method for RAkEL}
\usage{
\method{predict}{RAkELmodel}(
  object,
  newdata,
  probability = getOption("utiml.use.probs", TRUE),
  ...,
  cores = getOption("utiml.cores", 1),
  seed = getOption("utiml.seed", NA)
)
}
\arguments{
\item{object}{Object of class '\code{RAkELmodel}'.}

\item{newdata}{An object containing the new input data. This must be a
matrix, data.frame or a mldr object.}

\item{probability}{Logical indicating whether class probabilities should be
returned. (Default: \code{getOption("utiml.use.probs", TRUE)})}

\item{...}{Others arguments passed to the base algorithm prediction for all
subproblems.}

\item{cores}{The number of cores to parallelize the prediction. Values higher
than 1 require the \pkg{parallel} package. (Default:
\code{options("utiml.cores", 1)})}

\item{seed}{An optional integer used to set the seed. This is useful when
the method is run in parallel. (Default: \code{options("utiml.seed", NA)})}
}
\value{
An object of type mlresult, based on the parameter probability.
}
\description{
This function predicts values based upon a model trained by
\code{\link{rakel}}.
}
\examples{
model <- rakel(toyml, "RANDOM")
pred <- predict(model, toyml)
}
\seealso{
\code{\link[=rakel]{Random k Labelsets (RAkEL)}}
}
