% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{get_forceframe_tests_only}
\alias{get_forceframe_tests_only}
\title{Get only ForceFrame test data}
\usage{
get_forceframe_tests_only(start_date = NULL, profile_id = NULL)
}
\arguments{
\item{start_date}{(Optional) A UTC ISO 8601 datetime string (e.g. "2025-06-25T00:00:00Z") used to filter results by modification time. Input as a string.}

\item{profile_id}{(Optional) A specific profile ID to filter results for a single athlete. Input as a string.}
}
\value{
A data frame where each row corresponds to a ForceFrame test retrieved from the API. Returned invisibly.
}
\description{
Wrapper around \code{get_forceframe_tests()} to retrieve ForceFrame test data.
Intended for use when you want to fetch ForceFrame tests.
}
\examples{
\dontrun{
# Fetch all recent ForceFrame tests
tests <- get_forceframe_tests_only()
View(tests)

# Fetch ForceFrame tests for a specific profile
get_forceframe_tests_only(profile_id = "abcd1234-ab12-cd34-ef56-abcdef123456")
}
}
