% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericrules.R
\name{field_format}
\alias{field_format}
\title{Check whether a field conforms to a regular expression}
\usage{
field_format(x, pattern, type = c("glob", "regex"), ...)
}
\arguments{
\item{x}{Bare (unquoted) name of a variable. 
Otherwise a vector of class \code{character}. Coerced to character as 
necessary.}

\item{pattern}{\code{[character]} a regular expression}

\item{type}{\code{[character]} How to interpret \code{pattern}. In globbing,
the asterisk (`*`) is used as a wildcard that stands for 'zero or more
characters'.}

\item{...}{passed to grepl}
}
\description{
A convenience wrapper around \code{grepl} to make rule sets more readable.
}
\seealso{
Other format-checkers: 
\code{\link{field_length}()},
\code{\link{number_format}()}
}
\concept{format-checkers}
