% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_absdist.r
\name{bed_absdist}
\alias{bed_absdist}
\title{Compute absolute distances between intervals.}
\usage{
bed_absdist(x, y, genome)
}
\arguments{
\item{x}{\link{ivl_df}}

\item{y}{\link{ivl_df}}

\item{genome}{\link{genome_df}}
}
\value{
\link{ivl_df} with \code{.absdist} and \code{.absdist_scaled} columns.
}
\description{
Computes the absolute distance between the midpoint of each \code{x} interval and
the midpoints of each closest \code{y} interval.
}
\details{
Absolute distances are scaled by the inter-reference gap for the
chromosome as follows. For \code{Q} query points and \code{R} reference
points on a chromosome, scale the distance for each query point \code{i} to
the closest reference point by the inter-reference gap for each chromosome.
If an \code{x} interval has no matching \code{y} chromosome,
\code{.absdist} is \code{NA}.

\deqn{d_i(x,y) = min_k(|q_i - r_k|)\frac{R}{Length\ of\ chromosome}}

Both absolute and scaled distances are reported as \code{.absdist} and
\code{.absdist_scaled}.

Interval statistics can be used in combination with
\code{\link[dplyr:group_by]{dplyr::group_by()}} and \code{\link[dplyr:do]{dplyr::do()}} to calculate
statistics for subsets of data. See \code{vignette('interval-stats')} for
examples.
}
\examples{
genome <- read_genome(valr_example('hg19.chrom.sizes.gz'))

x <- bed_random(genome, seed = 1010486)
y <- bed_random(genome, seed = 9203911)

bed_absdist(x, y, genome)

}
\seealso{
\url{http://journals.plos.org/ploscompbiol/article?id=10.1371/journal.pcbi.1002529}

Other interval statistics: 
\code{\link{bed_fisher}()},
\code{\link{bed_jaccard}()},
\code{\link{bed_projection}()},
\code{\link{bed_reldist}()}
}
\concept{interval statistics}
