% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.r
\name{db}
\alias{db}
\alias{db_ucsc}
\alias{db_ensembl}
\title{Fetch data from remote databases.}
\usage{
db_ucsc(
  dbname,
  host = "genome-mysql.cse.ucsc.edu",
  user = "genomep",
  password = "password",
  port = 3306,
  ...
)

db_ensembl(
  dbname,
  host = "ensembldb.ensembl.org",
  user = "anonymous",
  password = "",
  port = 3306,
  ...
)
}
\arguments{
\item{dbname}{name of database}

\item{host}{hostname}

\item{user}{username}

\item{password}{password}

\item{port}{MySQL connection port}

\item{...}{params for connection}
}
\description{
Currently \code{db_ucsc} and \code{db_ensembl} are available for connections.
}
\examples{
\dontrun{
if(require(RMariaDB)) {
  ucsc <- db_ucsc('hg38')

  # fetch the `refGene` tbl
  tbl(ucsc, "refGene")

  # the `chromInfo` tbls have size information
  tbl(ucsc, "chromInfo")
}
}
\dontrun{
if(require(RMariaDB)) {
  # squirrel genome
  ensembl <- db_ensembl('spermophilus_tridecemlineatus_core_67_2')

  tbl(ensembl, "gene")
}
}

}
\seealso{
\url{https://genome.ucsc.edu/goldenpath/help/mysql.html}

\url{https://www.ensembl.org/info/data/mysql.html}
}
