% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundWaterEnvironments.R
\name{NormalizedBvalue}
\alias{NormalizedBvalue}
\title{B-value Normalization}
\usage{
NormalizedBvalue(Bvalues)
}
\arguments{
\item{Bvalues}{B-value values}
}
\value{
Vector of normalized and unitless B-value values.
}
\description{
Calculate the normalized B-value values of waters for a
structure.
}
\details{
The normalized B-value values are the number of standard deviations
from the mean for the water oxygens' B-values within the structure of
interest.

The B-value normalization exclusion value is user defined within the main
\code{\link[=ConservedWaters]{ConservedWaters()}} function but has a default value of 1.0.
}
\examples{
  set.seed(13)
  Bvalues <- sample(thrombin.1hai$atom$b, 10)
  Bvalues
  # [1] 32.53 22.36 24.91 42.11 36.60
  #     54.66 37.71 14.93 27.65 17.84
  NormalizedBvalue(Bvalues)
  # [1]  0.1158 -0.7252 -0.5143  0.9080  0.4523
  #      1.9457  0.5441 -1.3396 -0.2878 -1.0990

}
\references{
Oliviero Carugo. Correlation between occupancy and B value of
water molecules in protein crystal structures. \emph{Protein Engineering},
1999, \strong{12} (\emph{12}), pp 1021-1024.
\href{http://doi.org/10.1093/protein/12.12.1021}{DOI: 10.1093/protein/12.12.1021}
\href{http://www.ncbi.nlm.nih.gov/pubmed/10611392}{PMID: 10611392}
}
\seealso{
Other "Bound Water Environment": \code{\link{BoundWaterEnvironment.interact}},
  \code{\link{BoundWaterEnvironment.quality}},
  \code{\link{BoundWaterEnvironment}},
  \code{\link{Mobility}}, \code{\link{calcBvalue}},
  \code{\link{calcNearbyHydrationFraction}},
  \code{\link{calcNumHydrogenBonds}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
