% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{StandardizeLysineNames}
\alias{StandardizeLysineNames}
\title{Standardize Lysine Names}
\usage{
StandardizeLysineNames(residue.names)
}
\arguments{
\item{residue.names}{A vector of strings containing the three-letter residue
names (strings)}
}
\value{
vector of three-letter residue names with \emph{standardized} lysine
residue names
}
\description{
Standardize the de-protonated lysine three-letter residue name
to LYS.
}
\details{
The the de-protonated lysine three-letter residue name (LYN) is
converted to the standard "LYS" residue name. This function is part of the
\code{\link[=aaStandardizeNames]{aaStandardizeNames()}}.

\emph{\strong{NOTE}}: This is a non-public function.
}
\examples{
  \dontrun{
  residue.names <- c("HIS", "HID", "HIE", "HIP", "HSD", "HSE", "HSP",
                     "CYS", "CYM", "CYX", "ASP", "ASH", "GLU", "GLH",
                     "LYS", "LYN")
  StandardizeLysineNames(residue.names)
  # [1] "HIS" "HID" "HIE" "HIP" "HSD" "HSE" "HSP" "CYS" "CYM" "CYX"
  #     "ASP" "ASH" "GLU" "GLH" "LYS" "LYS"
  }

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}}, \code{\link{Nearby}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{utilities}
