% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm.anova.R
\name{rm.anova}
\alias{rm.anova}
\title{Simplified One-Way Repeated Measures Analysis of Variance}
\usage{
rm.anova(
  df,
  id,
  times,
  scores = NULL,
  correct = TRUE,
  sph = FALSE,
  phc = FALSE
)
}
\arguments{
\item{df}{data frame to read in.}

\item{id}{the main grouping variable by which \code{times} will be analyzed}

\item{times}{dependent variable values at the time points measured. Read in as a list of time point variables (e.g. \code{c("t1", "t2", "t3", ..., "tn")}), where the values represent the scores at the various time points. Read in as list if data are in wide form. If data are in long form, the \code{times} variable is one column (rather than multiple columns) in the data frame, and must be paired with the \code{scores} variable for actual values (listed below).}

\item{scores}{if data are in long form (where each group has multiple observations), a \code{scores} variable must be read in, which represents the values at the specific time points represented in the \code{times} variable.}

\item{correct}{logical (default set to \code{T}). Corrects the results in the repeated measures ANOVA table -- adjusts the degrees of freedom (\eqn{df}) by multiplying the sphericity assumed degrees of freedom (\eqn{df}) by the Greenhouse-Geisser Epsilon value. When set to \code{correct = F}, will print results of repeated measures ANOVA with sphericity assumed.}

\item{sph}{logical (default set to \code{F}). When set to \code{sph = T}, will print a sphericity tests table with Mauchly's W, as well as two Epsilon values (Greenhouse-Geisser and Huynh-Feldt).}

\item{phc}{logical (default set to \code{F}). When set to \code{sph = T}, will print a post-hoc comparisons table with Bonferroni's adjusted alpha levels (and p-values).}
}
\description{
This function simplifies the call for repeated measures ANOVA (rm.anova) on a given data frame. Also allows calls for sphericity correction (correct), as well as a sphericity test table (sph).
}
\examples{
data <- howell_aids_wide
rm.anova(data, student, c("t1","t2","t3"))

data2 <- howell_aids_long
rm.anova(data2, student, time, scores=knowledge)
}
