% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approxWeights.R
\name{approxWeights}
\alias{approxWeights}
\title{Monte Carlo approximation of chi-bar-square weights}
\usage{
approxWeights(x, df, q)
}
\arguments{
\item{x}{a vector of i.i.d. random realizations of the target chi-bar-square distribution}

\item{df}{a vector containing the degrees of freedom of the chi-squared components}

\item{q}{the empirical quantile of \code{x} used to choose the \eqn{p-2} values \eqn{c_1, \dots, c_{p-2}} (see Details)}
}
\value{
A vector containing the estimated weights, as well as their covariance matrix.
}
\description{
Approximation of the chi-bar-square weigths via Monte Carlo approximation.
}
\details{
The chi-bar-square distribution \eqn{\bar{\chi}^2(I,C)} is a mixture of chi-square distributions. The function provides
a method to approximate the weights of the mixture components, when the number of components is known as well as the
degrees of freedom of each chi-square distribution in the mixture, and given a vector of simulated values from the target
\eqn{\bar{\chi}^2(I,C)} distribution. Let us assume that there are \eqn{p} components in the mixture, with degrees of
freedom between \eqn{n_1} and \eqn{n_p}. By definition of a mixture distribution, we have :
\deqn{ P(\bar{\chi}^2(I,C) \leq c) = \sum_{i=n_1}^{n_p} w_i P(\chi^2_{i} \leq c)}
Choosing \eqn{p-2} values \eqn{c_1, \dots, c_{p-2}}, the function will generate a system of \eqn{p-2} equations
according to the above relationship, and add two additional relationships stating that the sum of all the weights is
equal to 1, and that the sum of odd weights and of even weights is equal to 1/2, so that we end up with a system a \eqn{p}
equations with \eqn{p} variables.
}
\author{
Charlotte Baey <\email{charlotte.baey@univ-lille.fr}>
}
