% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{vars_explore}
\alias{vars_explore}
\title{Searchable variable explorer with labelled variables}
\usage{
vars_explore(df, viewer = TRUE, digits = 2, font.size = "10pt",
  value.labels.width = 500, silent = TRUE, minimal = FALSE)
}
\arguments{
\item{df}{A data frame.}

\item{viewer}{Logical. Whether to show results as a searchable datatable
in RStudio's Viewer pane. Default is TRUE.}

\item{digits}{Numeric. How many digits to show for the statistics in the Viewer Pane.
Default is 2.}

\item{font.size}{String. Font size in the Viewer Pane. Default is "10pt".}

\item{value.labels.width}{Numeric. How many characters to include in the "Value
labels" and "Values" columns. Default is 500.}

\item{silent}{Logical. If FALSE, function will return the summary dataframe. Default is TRUE.}

\item{minimal}{If TRUE only the number of observations and missing values are shown.
Default is FALSE.}
}
\value{
If `silent = FALSE` the function returns the summary stats dataframe, each
       variable a row. This can be used for making summary tables, or viewed with
       the `View()` function.
}
\description{
Creates a summary dataframe that can be used in RStudio similar to the variable
explorer in Stata, but which also includes the summary statistics. If `viewer`
is TRUE (default) the result is shown in RStudio's Viewer pane as a searchable
datatable.
}
\details{
This is useful particularly if you have a large dataset with a very large number
of labelled variables with hard to remember names. Can also be used to generate
a table of summary statistics.
}
\examples{

qog <- rio::import("http://www.qogdata.pol.gu.se/dataarchive/qog_bas_cs_jan18.dta")
\donttest{
vars_explore(qog)
vars_explore(qog, minimal = TRUE)
vars_explore(qog, silent = FALSE, viewer = FALSE) \%>\% View()
}
qog_summary <- vars_explore(qog, silent = FALSE, viewer = FALSE)

}
