% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.R
\name{sample_fullSVC}
\alias{sample_fullSVC}
\title{Sample Function for GP-based SVC Model for Given Locations}
\usage{
sample_fullSVC(
  df.pars,
  nugget.sd,
  locs,
  cov.name = c("exp", "sph", "mat32", "mat52", "wend1", "wend2")
)
}
\arguments{
\item{df.pars}{(\code{data.frame(p, 3)}) \cr
Contains the mean and covariance parameters of SVCs. The three columns
must have the names \code{"mean"}, \code{"var"}, and \code{"scale"}.}

\item{nugget.sd}{(\code{numeric(1)}) \cr
Standard deviation of the nugget / error term.}

\item{locs}{(\code{numeric(n)} or \code{matrix(n, d)}) \cr
The numeric vector or matrix contains the observation locations and
therefore defines the number of observations to be \code{n}. For a vector,
we assume locations on the real line, i.e., \eqn{d=1}.}

\item{cov.name}{(\code{character}(1)) \cr
Character defining the covariance function, c.f. \code{\link{SVC_mle_control}}.}
}
\value{
\code{list} \cr
   Returns a list with the response \code{y}, model matrix
   \code{X}, a matrix \code{beta} containing the sampled SVC at given
   locations, a vector \code{eps} containing the error, and a matrix
   \code{locs} containing the original locations.
}
\description{
Samples SVC data at given locations. The SVCs parameters and the
covariance function have to be provided. The sampled model matrix contains an
intercept as a first column and further covariates sampled from a standard
normal. The SVCs are sampled according to their given parametrization and at
respective observation locations. The error vector sampled from a nugget
effect. Finally, the response vector is computed.
}
\examples{
set.seed(123)
# SVC parameters
(df.pars <- data.frame(
   var = c(2, 1),
   scale = c(3, 1),
   mean = c(1, 2)))
# nugget standard deviation
tau <- 0.5

# sample locations
s <- sort(runif(500, min = 0, max = 10))
SVCdata <- sample_fullSVC(
  df.pars = df.pars, nugget.sd = tau, locs = s, cov.name = "mat32"
)

}
