% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vascr_anova.R
\name{vascr_dunnett}
\alias{vascr_dunnett}
\title{Run ANOVA and Dunnett's comparisons on a vascr dataset}
\usage{
vascr_dunnett(data.df, unit, frequency, time, reference)
}
\arguments{
\item{data.df}{A vascr dataset}

\item{unit}{The unit to plot}

\item{frequency}{The frequency to plot}

\item{time}{The time to plot}

\item{reference}{Reference sample to compare against. If all comparisons are needed use vascr_anova}
}
\value{
A table with the results of the Dunnett's test
}
\description{
Run ANOVA and Dunnett's comparisons on a vascr dataset
}
\examples{
vascr_dunnett(data.df = growth.df, unit = "R", frequency = 4000, time = 100, reference = 6)
vascr_dunnett(growth.df, "R", 4000, time = list(50, 100), 6)

}
