% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vascr_anova.R
\name{vascr_plot_line_dunnett}
\alias{vascr_plot_line_dunnett}
\title{Create a line plot with Dunnett's statistics}
\usage{
vascr_plot_line_dunnett(
  data.df,
  unit = "R",
  frequency = 4000,
  time = 100,
  reference = "0_cells + HCMEC D3_Line",
  normtime = NULL
)
}
\arguments{
\item{data.df}{A vascr dataset}

\item{unit}{Unit to calculate}

\item{frequency}{Frequency to calculate from}

\item{time}{Time to calculate}

\item{reference}{Sample to reference testing against}

\item{normtime}{Time to normalise the line plot to, note this does not affect underlying statistical test}
}
\value{
A line plot, annotated with the P-values determined by Dunnett's test
}
\description{
Create a line plot with Dunnett's statistics
}
\examples{
vascr_plot_line_dunnett(small_growth.df, unit = "R", frequency = 4000, time = 25, 
    reference = "0_cells + HCMEC D3_Line")
vascr_plot_line_dunnett(small_growth.df, unit = "R", frequency = 4000, time = list(25,100), 
    reference = "0_cells + HCMEC D3_Line")
vascr_plot_line_dunnett(small_growth.df, unit = "R", frequency = 4000, time = 180, 
    reference = "20,000_cells + HCMEC D3_Line")

}
