% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vault_client_cubbyhole.R
\name{vault_client_cubbyhole}
\alias{vault_client_cubbyhole}
\title{Cubbyhole secret store}
\description{
Interact with vault's cubbyhole key-value store.  This is useful
for storing simple key-value data without versioning or metadata
(c.f. \code{\link{vault_client_kv2}}) that is scoped to your
current token only and not accessible to anyone else.  For more
details please see the vault documentation
\url{https://www.vaultproject.io/docs/secrets/cubbyhole/index.html}
}
\section{Methods}{


\describe{
\item{\code{read}}{
  Read a value from your cubbyhole
  \cr\emph{Usage:}\preformatted{read(path, field = NULL, metadata = FALSE)}

  \emph{Arguments:}
  \itemize{
    \item{\code{path}:   Path for the secret to read, such as \code{/cubbyhole/mysecret}
    }

    \item{\code{field}:   Optional field to read from the secret.  Each secret is stored as a key/value set (represented in R as a named list) and this is equivalent to using \code{[[field]]} on the return value. The default, \code{NULL}, returns the full set of values.
    }

    \item{\code{metadata}:   Logical, indicating if we should return metadata for this secret (lease information etc) as an attribute along with the values itself.  Ignored if \code{field} is specified.
    }
  }
}
\item{\code{write}}{
  Write data into your cubbyhole.
  \cr\emph{Usage:}\preformatted{write(path, data)}

  \emph{Arguments:}
  \itemize{
    \item{\code{path}:   Path for the secret to write, such as \code{/cubbyhole/mysecret}
    }

    \item{\code{data}:   A named list of values to write into the vault at this path. This \emph{replaces} any existing values.
    }
  }
}
\item{\code{list}}{
  List data in the vault at a give path.  This can be used to list keys, etc (e.g., at \code{/cubbyhole}).
  \cr\emph{Usage:}\preformatted{list(path, full_names = FALSE)}

  \emph{Arguments:}
  \itemize{
    \item{\code{path}:   The path to list
    }

    \item{\code{full_names}:   Logical, indicating if full paths (relative to the vault root) should be returned.
    }
  }

  \emph{Value}:
  A character vector (of zero length if no keys are found).  Paths that are "directories" (i.e., that contain keys and could themselves be listed) will be returned with a trailing forward slash, e.g. \code{path/}
}
\item{\code{delete}}{
  Delete a value from the vault
  \cr\emph{Usage:}\preformatted{delete(path)}

  \emph{Arguments:}
  \itemize{
    \item{\code{path}:   The path to delete
    }
  }
}
}
}

\examples{

server <- vaultr::vault_test_server(if_disabled = message)
if (!is.null(server)) {
  client <- server$client()

  # Shorter path for easier reading:
  cubbyhole <- client$secrets$cubbyhole
  cubbyhole

  # Write a value
  cubbyhole$write("cubbyhole/secret", list(key = "value"))
  # List it
  cubbyhole$list("cubbyhole")
  # Read it
  cubbyhole$read("cubbyhole/secret")
  # Delete it
  cubbyhole$delete("cubbyhole/secret")

  # cleanup
  server$kill()
}
}
