% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_labels.R
\name{mask_labels}
\alias{mask_labels}
\title{Mask categorical labels with random labels}
\usage{
mask_labels(x, prefix = "masked_group_")
}
\arguments{
\item{x}{a character or factor vector}

\item{prefix}{character string to use as prefix for masked labels.
Default is "masked_group_"}
}
\value{
a vector of the same type as input with masked labels
}
\description{
Assigns random new labels to each unique value in a character or factor
vector. The purpose is to blind data so analysts are not aware of treatment
allocation or categorical outcomes. Each unique original value gets a random
new label, and the assignment order is randomized to prevent correspondence
with the original order.
}
\examples{

# Example with character vector
set.seed(123)
treatment <- c("control", "treatment", "control", "treatment")
mask_labels(treatment)

# Example with custom prefix
set.seed(456)
condition <- c("A", "B", "C", "A", "B", "C")
mask_labels(condition, prefix = "group_")

# Example with factor vector
set.seed(789)
ecology <- factor(c("Desperate", "Hopeful", "Desperate", "Hopeful"))
mask_labels(ecology)

# Using with dataset column
data(williams)
set.seed(123)
williams$ecology_masked <- mask_labels(williams$ecology)
head(williams[c("ecology", "ecology_masked")])

}
\seealso{
\code{\link{mask_variables}} for masking multiple variables in a data frame,
\code{\link{mask_variables_rowwise}} for rowwise masking, and
\code{\link{mask_names}} for masking variable names.
}
\keyword{mask}
