% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_rep.R
\name{replicate.mean.ps}
\alias{replicate.mean.ps}
\title{Compares and combines paired-samples mean differences in original and follow-up studies}
\usage{
replicate.mean.ps(
  alpha,
  m11,
  m12,
  sd11,
  sd12,
  cor1,
  n1,
  m21,
  m22,
  sd21,
  sd22,
  cor2,
  n2
)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m11}{estimated mean for group 1 in original study}

\item{m12}{estimated mean for group 2 in original study}

\item{sd11}{estimated SD for group 1 in original study}

\item{sd12}{estimated SD for group 2 in original study}

\item{cor1}{estimated correlation of paired observations in orginal study}

\item{n1}{sample size in original study}

\item{m21}{estimated mean for group 1 in follow-up study}

\item{m22}{estimated mean for group 2 in follow-up study}

\item{sd21}{estimated SD for group 1 in follow-up study}

\item{sd22}{estimated SD for group 2 in follow-up study}

\item{cor2}{estimated correlation of paired observations in follow-up study}

\item{n2}{sample size in follow-up study}
}
\value{
A 4-row matrix. The rows are:
\itemize{
\item Row 1 summarizes the original study
\item Row 2 summarizes the follow-up study
\item Row 3 estimates the difference in mean differences
\item Row 4 estimates the average mean difference
}

The columns are:
\itemize{
\item Estimate - mean difference estimate (single study, difference, average)
\item SE - standard error
\item df - degrees of freedom
\item t - t-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function computes confidence intervals from an original study and a
follow-up study where the effect size is a paired-samples mean difference.
Confidence intervals for the difference and average effect size are also
computed. Equality of variances within or across studies is not assumed.
A Satterthwaite adjustment to the degrees of freedom is used to
improve the accuracy of the confidence intervals for the difference and
average. The same results can be obtained using the \link[vcmeta]{meta.lc.mean.ps}
function with appropriate contrast coefficients. The confidence level for
the difference is 1 – 2*alpha, which is recommended for equivalence testing.
}
\examples{
replicate.mean.ps(.05, 86.22, 70.93, 14.89, 12.32, .765, 20, 
                       84.81, 77.24, 15.68, 16.95, .702, 75)

#  Should return:
#                     Estimate       SE        t            p  
# Original:              15.29 2.154344 7.097288 9.457592e-07 
# Follow-up:              7.57 1.460664 5.182575 1.831197e-06 
# Original - Follow-up:   7.72 2.602832 2.966000 5.166213e-03 
# Average:               11.43 1.301416 8.782740 1.010232e-10 
#                              LL       UL       df
# Original:             10.780906 19.79909 19.00000
# Follow-up:             4.659564 10.48044 74.00000
# Original - Follow-up:  3.332885 12.10712 38.40002
# Average:               8.796322 14.06368 38.40002


}
\references{
\insertRef{Bonett2021}{vcmeta}
}
