% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert_cassette.R
\name{insert_cassette}
\alias{insert_cassette}
\title{Insert a cassette to record HTTP requests}
\usage{
insert_cassette(
  name,
  record = NULL,
  match_requests_on = NULL,
  update_content_length_header = FALSE,
  allow_playback_repeats = FALSE,
  serialize_with = NULL,
  persist_with = NULL,
  preserve_exact_body_bytes = NULL,
  re_record_interval = NULL,
  clean_outdated_http_interactions = NULL
)
}
\arguments{
\item{name}{The name of the cassette. vcr will check this to ensure it
is a valid file name. Not allowed: spaces, file extensions, control
characters (e.g., \verb{\\n}), illegal characters ('/', '?', '<', '>', '\\', ':',
'*', '|', and '\"'), dots alone (e.g., '.', '..'), Windows reserved
words (e.g., 'com1'), trailing dots (can cause problems on Windows),
names longer than 255 characters. See section "Cassette names"}

\item{record}{The record mode (default: \code{"once"}). See \link{recording} for a
complete list of the different recording modes.}

\item{match_requests_on}{List of request matchers
to use to determine what recorded HTTP interaction to replay. Defaults to
\verb{["method", "uri"]}. The built-in matchers are "method", "uri", "host",
"path", "headers", "body" and "query"}

\item{update_content_length_header}{(logical) Whether or
not to overwrite the \code{Content-Length} header of the responses to
match the length of the response body. Default: \code{FALSE}}

\item{allow_playback_repeats}{(logical) Whether or not to
allow a single HTTP interaction to be played back multiple times.
Default: \code{FALSE}.}

\item{serialize_with}{(character) Which serializer to use.
Valid values are "yaml" (default) and "json". Note that you can have
multiple cassettes with the same name as long as they use different
serializers; so if you only want one cassette for a given cassette name,
make sure to not switch serializers, or clean up files you no longer need.}

\item{persist_with}{(character) Which cassette persister to
use. Default: "file_system". You can also register and use a
custom persister.}

\item{preserve_exact_body_bytes}{(logical) Whether or not
to base64 encode the bytes of the requests and responses for
this cassette when serializing it. See also \code{preserve_exact_body_bytes}
in \code{\link[=vcr_configure]{vcr_configure()}}. Default: \code{FALSE}}

\item{re_record_interval}{(integer) How frequently (in seconds) the
cassette should be re-recorded. default: \code{NULL} (not re-recorded)}

\item{clean_outdated_http_interactions}{(logical) Should outdated
interactions be recorded back to file? default: \code{FALSE}}
}
\value{
an object of class \code{Cassette}
}
\description{
Insert a cassette to record HTTP requests
}
\details{
Cassette names:
\itemize{
\item Should be meaningful so that it is obvious to you what test/function
they relate to. Meaningful names are important so that you can quickly
determine to what test file or test block a cassette belongs. Note
that vcr cannot check that your cassette names are meaningful.
\item Should not be duplicated. Duplicated cassette names would lead to a
test using the wrong cassette.
\item Should not have spaces. Spaces can lead to problems in using file
paths.
\item Should not include a file extension. vcr handles file extensions for
the user.
\item Should not have illegal characters that can lead to problems in using
file paths: \code{/}, \verb{?}, \code{<}, \code{>}, \verb{\\}, \code{:}, \code{*}, \code{|}, and \verb{\"}
\item Should not have control characters, e.g., \verb{\n}
\item Should not have just dots, e.g., \code{.} or \code{..}
\item Should not have Windows reserved words, e.g., \code{com1}
\item Should not have trailing dots
\item Should not be longer than 255 characters
}

\code{vcr::check_cassette_names()} is meant to be run during your tests, from
a \code{setup-pkgname.R} file inside the \code{tests/testthat} directory. It only
checks that cassette names are not duplicated. Note that if you do need
to have duplicated cassette names you can do so by using the
\code{allowed_duplicates} parameter in \code{check_cassette_names()}. A helper
function \code{check_cassette_names()} runs inside
\code{\link[=insert_cassette]{insert_cassette()}} that checks that cassettes do
not have: spaces, file extensions, unaccepted characters (slashes)
}
\section{Cassette options}{


Default values for arguments controlling cassette behavior are
inherited from vcr's global configuration. See \code{\link[=vcr_configure]{vcr_configure()}} for a
complete list of options and their default settings. You can override these
options for a specific cassette by changing an argument's value to something
other than \code{NULL} when calling either \code{insert_cassette()} or
\code{use_cassette()}.
}

\examples{
\dontrun{
library(vcr)
library(crul)
vcr_configure(dir = tempdir())
webmockr::webmockr_allow_net_connect()

(x <- insert_cassette(name = "leo5"))
current_cassette()
x$new_recorded_interactions
x$previously_recorded_interactions()
cli <- crul::HttpClient$new(url = "https://httpbin.org")
cli$get("get")
x$new_recorded_interactions # 1 interaction
x$previously_recorded_interactions() # empty
webmockr::stub_registry() # not empty
# very important when using inject_cassette: eject when done
x$eject() # same as eject_cassette("leo5")
x$new_recorded_interactions # same, 1 interaction
x$previously_recorded_interactions() # now not empty
## stub_registry now empty, eject() calls webmockr::disable(), which
## calls the disable method for each of crul and httr adadapters,
## which calls webmockr's remove_stubs() method for each adapter
webmockr::stub_registry()

# cleanup
unlink(file.path(tempdir(), "leo5.yml"))
}
}
\seealso{
\code{\link[=use_cassette]{use_cassette()}}, \code{\link[=eject_cassette]{eject_cassette()}}
}
