% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampler.R
\name{sampler}
\alias{sampler}
\title{Sampler Function}
\usage{
sampler(
  n,
  design,
  type = c("spherical", "cuboidal", "lhs", "mlhs", "slhs", "rslhs", "custom"),
  at = FALSE,
  custom.fun = NULL,
  ...
)
}
\arguments{
\item{n}{number of points to sample}

\item{design}{design for which the sample is required (either a matrix or data frame)}

\item{type}{type of design region/sampling method. One of "spherical", "cuboidal", 
"lhs", "mlhs", "slhs", "rslhs" or "custom". Option "custom" requires \code{custom.fun} to be
non-\code{NULL}.}

\item{at}{logical; should sampling be done on the surface of hyperspheres or hypercubes? 
Not used for LHS methods.}

\item{custom.fun}{A custom sampling function, used in conjunction with \code{type = "custom"}. The
first and second arguments must be the sample size and dimension respectively.}

\item{\dots}{other arguments passed to the underlying sampling functions.}
}
\value{
Matrix with samples as rows, with S3 class \code{smpl}
}
\description{
This is a wrapper for the sampling funcions of the \pkg{vdg} package. It extracts design properties from the 
design passed to it to take appropriate samples.
}
\examples{
## Default spherical design region
set.seed(1896)
samp1 <- sampler(n = 100, design = expand.grid(x = -1:1, y = -1:1))
plot(samp1)

## Supplying a custom sampling function based on lhs::improvedLHS()
library("lhs")
sfun <- function(n, k, dup = 1) 2 * improvedLHS(n, k, dup = dup) - 1
samp2 <- sampler(n = 100, design = expand.grid(x = -1:1, y = -1:1),
                 type = "custom", custom.fun = sfun)
plot(samp2)
}
\references{
Pieter C. Schoonees, Niel J. le Roux, Roelof L.J. Coetzer (2016). Flexible Graphical Assessment of 
Experimental Designs in R: The vdg Package. \emph{Journal of Statistical Software}, 74(3), 1-22. 
\doi{10.18637/jss.v074.i03}.
}
\seealso{
\code{\link{runif_sphere}}, \code{\link{runif_cube}}, \code{\link{LHS}}, 
\code{\link{MLHS}}, \code{\link{SLHS}}, \code{\link{RSLHS}}
}
\author{
Pieter C. Schoonees
}
