% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVectorIndex.R
\name{getVectorIndex}
\alias{getVectorIndex}
\title{Calculate vector index}
\usage{
getVectorIndex(
  collections,
  pools,
  interval,
  target_disease,
  pt_estimate,
  scale = 1000,
  agency = NULL,
  species = NULL,
  trap = NULL,
  sex = NULL,
  trapnight_min = 1,
  trapnight_max = NULL,
  separate_by = NULL,
  wide = FALSE
)
}
\arguments{
\item{collections}{Collections data retrieved from `getArthroCollections()`}

\item{pools}{Pools data retrieved from `getPools()`}

\item{interval}{Calculation interval for vector index, accepts “collection_date”,“Biweek”,“Week”, and “Month}

\item{target_disease}{The disease to calculate infection rate for–i.e. “WNV”. Disease acronyms are the accepted input. To see a list of disease acronyms, run `unique(pools$target_acronym)`}

\item{pt_estimate}{The estimation type for infection rate. Options include: “mle”,“bc-”mle”, “mir”}

\item{scale}{Constant to multiply infection rate, default is 1000}

\item{agency}{An optional vector for filtering agency by character code}

\item{species}{An optional vector for filtering species. Species_display_name is the accepted notation.To see a list of species present in your data run unique(collections$species_display_name). If species is unspecified, the default NULL will return data for all species in data.}

\item{trap}{An optional vector for filtering trap type by acronym. Trap_acronym is the is the accepted notation. Run unique(collections$trap_acronym) to see trap types present in your data. If trap is unspecified, the default NULL will return data for all trap types.}

\item{sex}{An optional vector for filtering sex type. Accepts 'male', 'female',or 'other'. If sex is unspecified, the default NULL will return data for female sex.}

\item{trapnight_min}{Minimum trap night restriction for calculation. Default is 1.}

\item{trapnight_max}{Maximum trap night restriction for calculation. Default is no restriction.}

\item{separate_by}{Separate/group the calculation by 'trap','species' or 'agency'. Default NULL does not separate.}

\item{wide}{Should the data be returned in wide/spreadsheet format}
}
\value{
Dataframe containing the vector index calculation
}
\description{
`getVectorIndex()`requires at least five years prior to the target_year of arthro collections data to calculate for the specified parameters. The function uses the methods of the Gateway Abundance Anomaly calculator, and will not work if there is fewer than five years of data present.
}
\examples{
getVectorIndex(sample_collections, sample_pools, "Month", "WNV", "mle", wide = FALSE )
}
