% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tax.child.r
\name{child}
\alias{child}
\title{Search taxonomic reference lists including concept synonomy and taxonomic hierarchy.}
\usage{
child(x, refl, gen = 3, syn = FALSE, include.parent = FALSE, quiet = FALSE, ...)
}
\arguments{
\item{x}{Species number, lettercode or species name(s)}

\item{refl}{Taxonomic reference list}

\item{gen}{Number of child generations to return}

\item{syn}{Should synonyms be included in results}

\item{include.parent}{Should the parent taxon be included in results}

\item{quiet}{Hide screen messages}

\item{\dots}{additional paarmeters for function tax}
}
\description{
Search all (accepted) children of a taxon down to gen generations
}
\details{
\dfn{concept}: GermanSL is a list with a single taxon view according to the standard lists of the different taxon groups (e.g Wisskirchen and Haeupler for higher plants, see).
  Nevertheless a huge number of synonyms is included which allows in many cases the transformation into different concepts.
  For illustration the concept of \emph{Armeria maritima} from Korneck 1996 is included, which accepts e.g. \emph{Armeria maritima ssp. bottendorfensis}.
  \dfn{parse.taxa}: parse genus and epitheta from name strings.
  \dfn{taxname.removeAuthors} Remove name authors from full scientific name strings.
}
\references{
Jansen, F. and Dengler, J. (2008) GermanSL - eine universelle taxonomische Referenzliste für Vegetationsdatenbanken. Tuexenia, 28, 239-253.
}
\author{
Florian Jansen \email{florian.jansen@uni-rostock.de}
}
