% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_emis.R
\name{split_emis}
\alias{split_emis}
\title{Split street emissions based on a grid}
\usage{
split_emis(net, distance, verbose = TRUE)
}
\arguments{
\item{net}{A spatial dataframe of class "sp" or "sf". When class is "sp"
it is transformed to "sf" with emissions.}

\item{distance}{Numeric distance or a grid with class "sf".}

\item{verbose}{Logical, to show more information.}
}
\description{
\code{\link{split_emis}} split street emissions into a grid.
}
\examples{
{
data(net)
g <- make_grid(net, 1/102.47/2) #500m in degrees
names(net)
dim(net)
netsf <- sf::st_as_sf(net)[, "ldv"]
x <- split_emis(netsf, g)
dim(x)
}
}
