% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_merge.R
\name{emis_merge}
\alias{emis_merge}
\title{Merge several emissions files returning data-frames or 'sf' of lines}
\usage{
emis_merge(
  pol = "CO",
  what = "STREETS.rds",
  streets = T,
  net,
  FN = "sum",
  ignore,
  path = "emi",
  crs,
  under = "after",
  as_list = FALSE,
  k = 1,
  verbose = TRUE
)
}
\arguments{
\item{pol}{Character. Pollutant.}

\item{what}{Character. Word to search the emissions names, "STREETS", "DF" or
whatever name. It is important to include the extension .'rds'. For instance,
If you have several files "XX_CO_STREETS.rds", what should be "STREETS.rds"}

\item{streets}{Logical. If true, \code{\link{emis_merge}} will read the street
emissions created with \code{\link{emis_post}} by "streets_wide", returning an
object with class 'sf'. If false, it will read the emissions data-frame and
rbind them.}

\item{net}{'Spatial feature' or 'SpatialLinesDataFrame' with the streets.
It is expected #' that the number of rows is equal to the number of rows of
street emissions. If #' not, the function will stop.}

\item{FN}{Character indicating the function. Default is "sum"}

\item{ignore}{Character; Which pollutants or other charavter would you like to remove?}

\item{path}{Character. Path where emissions are located}

\item{crs}{coordinate reference system in numeric format from
http://spatialreference.org/ to transform/project spatial data using sf::st_transform}

\item{under}{"Character"; "after" when you stored your pollutant x as 'X_'
"before" when '_X' and "none" for merging directly the files.}

\item{as_list}{"Logical"; for returning the results as list or not.}

\item{k}{factor}

\item{verbose}{Logical to display more information or not. Default is TRUE}
}
\value{
'Spatial feature' of lines or a dataframe of emissions
}
\description{
\code{\link{emis_merge}} reads rds files and returns a data-frame
 or an object of 'spatial feature' of streets, merging several files.
}
\examples{
\dontrun{
# Do not run

}
}
