% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_emfac.R
\name{emis_emfac}
\alias{emis_emfac}
\title{Emission calculation based on EMFAC emission factors}
\usage{
emis_emfac(
  ef,
  veh,
  lkm,
  speed,
  vehname,
  pol = "CO_RUNEX",
  modelyear = 2021:1982,
  noyear = 2022,
  hours = paste0("S", 1:24),
  vkm = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{ef}{Character path to EMFAC ef (g/miles)}

\item{veh}{Vehicles data.frame}

\item{lkm}{Distance per street-link in miles}

\item{speed}{Speed data.frame in niles/hour}

\item{vehname}{numeric vector for heavy good vehicles or trucks}

\item{pol}{character, "CO_RUNEX"}

\item{modelyear}{numeric vector, 2021:1982}

\item{noyear}{newest numeric year to take out from ef}

\item{hours}{Character, name of hours in speed, paste0("S", 1:24) data-frame profile for passenger cars, 24 hours only.}

\item{vkm}{logical, to return vkm}

\item{verbose}{logical, to show more information}
}
\value{
data.table with emission estimation in long format
}
\description{
\code{\link{emis_emfac}} estimates emissions based on
an emission factors database from EMFAC.You must download the
emission factors from EMFAC website.
}
\examples{
\dontrun{
# do not run
}
}
