% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velox_cast.R
\name{VeloxRaster_as.RasterStack}
\alias{VeloxRaster_as.RasterStack}
\title{Cast a VeloxRaster as a RasterStack object}
\arguments{
\item{assign_data_type}{Boolean indicating whether the dataType attribute of the returned RasterStack should be set.
If TRUE, the dataType attribute is set to the smallest possible data type.}
}
\value{
A RasterStack object.
}
\description{
\code{as.RasterStack} creates a RasterStack object from a VeloxRaster.
}
\examples{
## Make VeloxRaster with two bands
mat1 <- matrix(1:100, 10, 10)
mat2 <- matrix(100:1, 10, 10)
vx <- velox(list(mat1, mat2), extent=c(0,1,0,1), res=c(0.1,0.1),
      crs="+proj=longlat +datum=WGS84 +no_defs")
## Cast to RasterStack
library(raster)
rs <- vx$as.RasterStack()

}

