% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velox_extract.R
\name{VeloxRaster_extract_points}
\alias{VeloxRaster_extract_points}
\title{Extract Values Given Points}
\arguments{
\item{sp}{A SpatialPoints* object or a sf* POINT object.}
}
\value{
A numeric matrix. One row per element in \code{sp}, one column per band in the VeloxRaster.
}
\description{
Given a set of points, returns all raster values of the cells with which they intersect.
}
\examples{
## Make VeloxRaster with two bands
set.seed(0)
mat1 <- matrix(rnorm(100), 10, 10)
mat2 <- matrix(rnorm(100), 10, 10)
vx <- velox(list(mat1, mat2), extent=c(0,1,0,1), res=c(0.1,0.1),
            crs="+proj=longlat +datum=WGS84 +no_defs")
## Make SpatialPoints
library(sp)
library(rgeos)
coord <- cbind(runif(10), runif(10))
spoint <- SpatialPoints(coords=coord)
## Extract
vx$extract_points(sp=spoint)

}

