% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_hierarchically_sparse_data.R
\name{genHierSparseBeta}
\alias{genHierSparseBeta}
\title{function to generate coefficient matrix with hierarchical sparsity}
\usage{
genHierSparseBeta(ncats, nvars, hier.sparsity.param = 0.5,
  avg.hier.zeros = NULL, effect.size.max = 0.5,
  misspecification.prop = 0)
}
\arguments{
\item{ncats}{number of categories to stratify on}

\item{nvars}{number of variables}

\item{hier.sparsity.param}{parameter between 0 and 1 which determines how much hierarchical sparsity there is. To achieve
a desired total level of sparsity among the variables with hierarchical sparsity, this parameter can be estimated using the
function 'estimate.hier.sparsity.param'}

\item{avg.hier.zeros}{desired percent of zero variables among the variables with hierarchical zero patterns. If this is specified, it will
override the given hier.sparsity.param value and estimate it. This takes a while}

\item{effect.size.max}{maximum magnitude of the true effect sizes}

\item{misspecification.prop}{proportion of variables with hierarchical missingness misspecified}
}
\description{
function to generate coefficient matrix with hierarchical sparsity
}
\examples{
set.seed(123)

# estimate hier.sparsity.param for 0.15 total proportion of nonzero variables
# among vars with hierarchical zero patterns
# NOT RUN: Takes a long time
# hsp <- estimate.hier.sparsity.param(ncats = 3, nvars = 25, avg.hier.zeros = 0.15, nsims = 100)
# the above results in the following value
hsp <- 0.6341772

# check that this does indeed achieve the desired level of sparsity
mean(replicate(100, mean(genHierSparseBeta(ncats = 3, 
                           nvars = 25, hier.sparsity.param = hsp) != 0)  ))

sparseBeta <- genHierSparseBeta(ncats = 3, nvars = 25, hier.sparsity.param = hsp)

}
