% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mse.R
\name{run_lcmcr}
\alias{run_lcmcr}
\title{Calculate multiple systems estimation estimates using the Bayesian
Non-Parametric Latent-Class Capture-Recapture model developed by Daniel
Manrique-Vallier (2016).}
\usage{
run_lcmcr(
  stratum_data_prepped,
  stratum_name,
  min_n = 1,
  K,
  buffer_size,
  sampler_thinning,
  seed,
  burnin,
  n_samples,
  posterior_thinning
)
}
\arguments{
\item{stratum_data_prepped}{A data frame with all records in the stratum of interest
documented by sources considered valid for estimation (i.e., there should be
no rows with all 0's). Columns indicating sources should be prefixed with
\code{in_} and should be numeric with 1 indicating that an individual was
documented in the source and 0 indicating that an individual was not
documented in the source.}

\item{stratum_name}{An identifier for the stratum.}

\item{min_n}{The minimum number of records that must appear in a source to be
considered valid for estimation. \code{min_n} should never be less than or equal to
0; the default value is 1.}

\item{K}{The maximum number of latent classes to fit.}

\item{buffer_size}{Size of the tracing buffer.}

\item{sampler_thinning}{Thinning interval for the tracing buffer.}

\item{seed}{Integer seed for the internal random number generator.}

\item{burnin}{Number of burn in iterations.}

\item{n_samples}{Number of samples to be generated. Samples are taken one
every \code{posterior_thinning} iterations of the sampler. Final number of samples
from the posterior is \code{n_samples} divided by 1,000.}

\item{posterior_thinning}{Thinning interval for the sampler.}
}
\value{
A data frame with four columns and \code{n_samples} divided by 1,000 rows.
\code{N} is the draws from the posterior distribution, \code{valid_sources} is a string
indicating which sources were used in the estimation, \code{n_obs} is the number of
observations in the stratum of interest, and  \code{stratum_name} is the stratum
identifier.
}
\description{
Calculate multiple systems estimation estimates using the Bayesian
Non-Parametric Latent-Class Capture-Recapture model developed by Daniel
Manrique-Vallier (2016).
}
\examples{
\donttest{
set.seed(19481210)
library(dplyr)

in_A <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.45, 0.65))
in_B <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.5, 0.5))
in_C <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.75, 0.25))
in_D <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(1, 0))

my_stratum <- tibble::tibble(in_A, in_B, in_C, in_D) \%>\%
    dplyr::mutate(rs = rowSums(.)) \%>\%
    dplyr::filter(rs >= 1) \%>\%
    dplyr::select(-rs)
run_lcmcr(stratum_data_prepped = my_stratum, stratum_name = "my_stratum",
          K = 4, buffer_size = 10000, sampler_thinning = 1000, seed = 19481210,
          burnin = 10000, n_samples = 10000, posterior_thinning = 500)
}
}
\references{
\insertRef{manriquevallier2016}{verdata}
}
