% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VirtualArray-subset.R
\name{[,VirtualArray,ANY,ANY-method}
\alias{[,VirtualArray,ANY,ANY-method}
\alias{[,VirtualArray-method}
\title{Indexing to extract subsets of a 'code{\link[via:XArray-class]{VirtualArray}}'-class object}
\usage{
\S4method{[}{VirtualArray,ANY,ANY}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{An object from a \code{\link[via:XArray-class]{VirtualArray}}-derived class.}

\item{i}{subscript of the first dimension(rows) or vector-like subsetting.}

\item{j}{subscript of the second dimension (columns).}

\item{...}{subscript of additional dimensions.}

\item{drop}{\code{logical} in case the result of subsetting is a single element, should the \code{\link[via:XArray-class]{VirtualArray}}-derived wrapper be dropped?}
}
\value{
An object from either the same class as \code{x} or the class of its elements.
}
\description{
Single bracket \code{'['} refers to indices and names within the '\code{\link[via:XArray-class]{VirtualArray}}'-class object. Use double brackets to extract layers based on their names (in the \code{@stack}).
}
\examples{
ex <- rastex()
# numeric subsetting
firstThree <- ex[1:3]
# character subsetting
second <- ex["d"]
# logical subsetting
subscript <- rep(FALSE, length(ex))
subscript[2] <- TRUE
second2 <- ex[subscript]
data(paleocoastlines)
present<- paleocoastlines["0", ]
allMargin <- paleocoastlines[, "margin"]

}
