% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groundfilter.R
\name{ground.filter}
\alias{ground.filter}
\title{Additionnal filters after first ground and vegetation segmentation}
\usage{
ground.filter(data, grid.res, pix.percentile, global.percentile)
}
\arguments{
\item{data}{a data.frame containing the xyz and point class of ground points segmented with the \code{\link{class.ground}} function}

\item{grid.res}{resolution of a grid's pixel. Default = 1}

\item{pix.percentile}{the percentile filter to use in each pixel. Default = 50}

\item{global.percentile}{the percentile filter to use at the plot scale. Default = 95}
}
\value{
a data.frame containing the xyz coordinates plus the point class: "ground" or "reclass to veg." if the point was classed as vegetation.
}
\description{
The \strong{ground.filter} function provides the ability to filter an output from the \code{\link{class.ground}} function.
The first filter removes from the ground point cloud every point with a \emph{z} value above \emph{pix.percentile} threshold within a single pixel of \emph{grid.res} resolution.
The second filter is a global percentile filter that removes from the ground point cloud the points with a within-pixel \emph{z} value above \emph{global.percentile} threshold.
}
\examples{
library(viewshed3d)
data(TLSclass)

ground=subset(TLSclass,TLSclass[,4]=='ground')
resegmented=ground.filter(ground)

ground = subset(resegmented,resegmented[,4]=='ground')
vegetation = subset(resegmented,resegmented[,4]=='reclass to veg.')

library(rgl)
open3d()
plot3d(ground,col="brown",add=TRUE)
plot3d(vegetation,col="darkgreen",add=TRUE)
}
