% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstructground.R
\name{reconstruct.ground}
\alias{reconstruct.ground}
\title{Reconstruct the missing portions of a TLS scene's ground}
\usage{
reconstruct.ground(data, grid.res, scene.radius, scene.center, shape,
  method, d, k, reconstruct.all)
}
\arguments{
\item{data}{a data.frame containing the xyz and point class of ground points segmented with the \code{\link{class.ground}} and optionally with the \code{\link{ground.filter}} functions}

\item{grid.res}{the resolution of a grid used to locate the new points to add. Default = 0.05}

\item{scene.radius}{optional. Define scene radius relative to the 0,0,0 coordinate. Should be used after the scene was reshaped with the \code{\link{reshape.scene} function}}

\item{scene.center}{a vector containing the xyz coordinates of the scene center for reshaping}

\item{shape}{the shape of the scene radius reshaping (see \code{\link{reshape.scene}} function for more details)}

\item{method}{the method to find the neighboring points.
If = "distance" all the points located within a distance \emph{d} are used to estimate \emph{z}.
If = "k-nearest" only the \emph{k} nearest neighbors are used.}

\item{d}{set the distance of neighboring points if \emph{method} = "distance". Default = 1.}

\item{k}{set the number of neighboring points if \emph{method} = "k-nearest". Default = 5.}

\item{reconstruct.all}{logical. If \emph{TRUE} the entire ground surface is reconstructed. If FALSE only the ground
portions with missing points are reconstructed}
}
\value{
a data.frame containing the xyz coordinates plus the class of the reconstructed points
}
\description{
The \strong{reconstruct.ground} function is used to reconstruct the missing portions of the ground after segmentation of the TLS scene
with the \code{\link{class.ground}} function. It creates a grid of pixels of user defined resolution and attributes to each pixel an elevation
value (i.e., a \emph{z} value) calculated as the average value (weighted by distance) of the neighboring ground points. Two methods for neighboring points
selection are provided: k nearest neighbors or absolute cartesian distance.
}
\examples{

library(viewshed3d)
data(TLSclass)
ground=subset(TLSclass,TLSclass[,4]=='ground')
reconstructed=reconstruct.ground(ground,grid.res = 0.2)

library(rgl)
open3d()
plot3d(reconstructed,add=TRUE)

}
\seealso{
\code{\link{reconstruct.ground.par}} for more effecient computation.
}
