% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viralpreds.R
\name{viralpreds}
\alias{viralpreds}
\title{Train and Evaluate Many Regression Models for Predicting Viral Load or CD4 Counts}
\usage{
viralpreds(target, pliegues, repeticiones, rejilla, semilla, data)
}
\arguments{
\item{target}{A character string specifying the column name of the target variable to predict.}

\item{pliegues}{An integer specifying the number of folds for cross-validation.}

\item{repeticiones}{An integer specifying the number of times the cross-validation should be repeated.}

\item{rejilla}{An integer specifying the number of grid search iterations for tuning hyperparameters.}

\item{semilla}{An integer specifying the seed for random number generation to ensure reproducibility.}

\item{data}{A data frame containing the predictors and the target variable.}
}
\value{
A list containing two elements: \code{predictions} (a vector of predicted values for the target variable)
and \code{RMSE} (the root mean square error of the best model).
}
\description{
This function builds, trains, and evaluates a set of statistical learning models for predicting viral load or CD4 counts.
It implements multiple pre-processing options (simple, normalized, full quadratic) and model types (MARS, neural network, KNN).
The best model is selected based on RMSE.
}
\examples{
\donttest{
library(tidyverse)
library(baguette)
library(kernlab)
library(kknn)
library(ranger)
library(rules)
library(glmnet)
# Define the function to impute values in the undetectable range
set.seed(123)
impute_undetectable <- function(column) {
ifelse(column <= 40,
      rexp(sum(column <= 40), rate = 1/13) + 1,
            column)
            }
# Apply the function to all vl columns using purrr's map_dfc
library(viraldomain)
data("viral", package = "viraldomain")
viral_imputed <- viral |>
mutate(across(starts_with("vl"), ~impute_undetectable(.x)))
traindata <- viral_imputed
target <- "cd_2022"
viralvars <- c("vl_2019", "vl_2021", "vl_2022")
logbase <- 10
pliegues <- 5
repeticiones <- 2
rejilla <- 2
semilla <- 123
viralpreds(target, pliegues, repeticiones, rejilla, semilla, traindata)
}
}
