% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{splitNameLevel}
\alias{splitNameLevel}
\title{Split name and level columns into the columns.}
\usage{
splitNameLevel(
  result,
  name = "group_name",
  level = "group_level",
  keep = FALSE,
  overall = FALSE
)
}
\arguments{
\item{result}{Omop result object (summarised_result or compared_result).}

\item{name}{Column with the names.}

\item{level}{Column with the levels.}

\item{keep}{Whether to keep the original group_name and group_level columns.}

\item{overall}{Whether to keep overall column if present.}
}
\value{
A dataframe with the specified name column values as columns.
}
\description{
Pivots the input dataframe so the values of the name columns are tranformed
into columns, which values come from the specified level column.
}
\examples{
mockSummarisedResult() |>
  splitNameLevel(name = "group_name",
                 level = "group_level",
                 keep = FALSE)

}
