% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatHeader.R
\name{formatHeader}
\alias{formatHeader}
\title{Create a header for gt and flextable objects}
\usage{
formatHeader(
  result,
  header,
  delim = "\\n",
  includeHeaderName = TRUE,
  includeHeaderKey = TRUE
)
}
\arguments{
\item{result}{A \verb{<summarised_result>}.}

\item{header}{Names of the variables to make headers.}

\item{delim}{Delimiter to use to separate headers.}

\item{includeHeaderName}{Whether to include the column name as header.}

\item{includeHeaderKey}{Whether to include the header key (header,
header_name, header_level) before each header type in the column names.}
}
\value{
A tibble with rows pivotted into columns with key names for
subsequent header formatting.
}
\description{
Pivots a \verb{<summarised_result>} object based on the column names in header,
generating specific column names for subsequent header formatting in
formatTable function.
}
\examples{
result <- mockSummarisedResult()

result |>
  formatHeader(
    header = c(
      "Study cohorts", "group_level", "Study strata", "strata_name",
      "strata_level"
    ),
    includeHeaderName = FALSE
  )
}
