% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vfstats.R
\name{vfaggregate}
\alias{vfaggregate}
\alias{vfmean}
\alias{vfretestdist}
\title{Statistical analyses for visual fields data}
\usage{
vfaggregate(vf, by = "date", fun = mean, ...)

vfmean(vf, by = "date", ...)

vfretestdist(vf, nbase = 1, nfollow = 1, alpha = 0.1, ...)
}
\arguments{
\item{vf}{a table with visual fields data. Data is rounded, which leaves
sensitivity data unchanged, but it is necessary for the nature of the
algorithm if the data passed are TD or PD values or summary stats such as
averages. Beware of the locations in the blind spot, which very likely need
to be removed}

\item{by}{aggregate by \code{date}, that is by id, eye, and date (default) or by
\code{eye}, that is by id and eye}

\item{fun}{a function to compute the summary statistics which can be applied to
all data subsets. The default is `\code{mean}`}

\item{...}{arguments to be passed to or from methods. A useful one to try
is type of quantile calculation `\code{type}` use in \code{\link{quantile}}}

\item{nbase}{number of visual fields to be used as baseline}

\item{nfollow}{number of visual fields to be used as follow up}

\item{alpha}{significance level to derive the conditional retest intervals.
Default value is \code{0.1}}
}
\value{
\code{vfaggregate} and \code{vfmean} return a vf data frame with aggregate values

\code{vfretestdist} returns a list with the following elements:
\itemize{
  \item\code{x} with all the test values (x-axis)
  \item\code{y} the distribution of retest dB values conditional to each
  test value in \code{x}. It is a list with as many entries as \code{x}
  \item\code{n} number of retest values conditional to each value in \code{x}.
  It is a list with as many entries as \code{x}
  \item\code{ymed} median for each value in \code{x}. It is a list with as
  many entries as \code{x}
  \item\code{ylow} quantile value for significance \code{1 - alpha / 2}
  for each value in \code{x}. It is a list with as many entries as \code{x}
  \item\code{yup} quantile value for significance \code{alpha / 2}
  for each value in \code{x}. It is a list with as many entries as \code{x}
}
Together \code{ylow} and \code{yup} represent the lower and upper limit of the
\code{(1 - alpha)\%} confidence intervals at each value \code{x}.
}
\description{
\itemize{
  \item\code{vfaggregate} computes summary statistics of visual field data
  \item\code{vfmean} computes the mean statistics of visual field data. It is
    a wrapper for vfaggregate but only to compute means
  \item\code{vfretestdist} computes the conditional distribution from test-retest data
}
}
\details{
\itemize{
  \item\code{vfaggregate} this is a restricted version of \code{\link{aggregate}}
    that only allows to use part of the key hierarchically, and operates on all
    data frames of the \code{VisualField} object. The restriction is that only
    aggregates that are allowed are `\code{newkey = c("id", "eye")}` and
    `\code{newkey = c("id", "eye", "date")}`. It returns the aggregated value for all
    numeric columns grouped and ordered by the new key (id and eye, or id, eye,
    and date). If the aggregate grouping is by \code{eye} and the function, then
    the \code{date} returned is the average.
}
}
\examples{
# aggregate by date
vfaggregate(vfpwgRetest24d2, by = "date")           # compute the mean
vfaggregate(vfpwgRetest24d2, by = "date", fun = sd) # compute standard deviation
# aggregate by eye
vfaggregate(vfpwgRetest24d2, by = "eye")           # compute the mean
vfaggregate(vfpwgRetest24d2, by = "eye", fun = sd) # compute standard deviation
# mean by date
vfmean(vfpwgRetest24d2, by = "date")
# mean by eye
vfmean(vfpwgRetest24d2, by = "eye")
# get the retest sensitivity data after removing the blind spot
retest <- vfretestdist(vfpwgRetest24d2, nbase = 1, nfollow = 1)

plot(0, 0, typ = "n", xlim = c(0, 40), ylim = c(0,40),
     xlab = "test in dB", ylab = "retest in dB", asp = 1)
for(i in 1:length(retest$x)) {
  points(rep(retest$x[i], length(retest$y[[i]])), retest$y[[i]],
         pch = 20, col = "lightgray", cex = 0.75)
}
lines(c(0,40), c(0,40), col = "black")
lines(retest$x, retest$ymed, col = "red")
lines(retest$x, retest$ylow, col = "red", lty = 2)
lines(retest$x, retest$yup, col = "red", lty = 2)
}
